window.onload = function(){

  //div 오디오 박스 
  const audioBox = document.getElementsByClassName('audio_box');
  

  //오디오박스에 요소 추가 반복문
  for (let i = 0; i < audioBox.length; i++) {

    audioBox[i].innerHTML = '<div class="music-container"><div class="navigation"><button class="action-btn">Play</button><button class="stop">stop</button></div><div class="music-info"><div class="progress-container"><div class="progress" style=""></div></div></div><audio src="" class="audio"></audio></div>'

    //오디오 폴더 경과 - 몇과
    let lesson = audioBox[i].getAttribute('data-lesson');
    
    
    //오디오 주소 가지고 오기
    document.querySelectorAll('.audio_box audio')[i].src = `./audio/${lesson}/${audioBox[i].id}.mp3`;
    //musicContainer[i] = document.getElementById(audioBox[i].id);

    //음원박스 위치 설정
    let pTop = audioBox[i].getAttribute('data-pT');
    let pLeft = audioBox[i].getAttribute('data-pL');

    audioBox[i].style.top = `${pTop}px`;
    audioBox[i].style.left = `${pLeft}px`;

  }

  //오디오 버튼 변수


  var current_audio_idx = null; // 현재 선택 된 오디오.

  var playButn = document.querySelectorAll('.action-btn');
  var stopButn = document.querySelectorAll('.stop')
  var audio = document.querySelectorAll('.audio');
  var progress = document.querySelectorAll('.progress');
  var progressContainer = document.querySelectorAll('.progress-container');

  var progressPercent = '';

  //console.log('playButn', playButn);

  for (let index = 0; index < playButn.length; index++) {
    const element = playButn[index];
    element.addEventListener('click', () => {
      current_audio_idx = index;
      const isPlaying = document.querySelectorAll('.music-container')[current_audio_idx].classList.contains('play');
      console.log('isPlaying', isPlaying);
      if (isPlaying) {
        pauseSong();
      }
      else {
        playSong();
      }

    });
  }

  for (let index = 0; index < stopButn.length; index++) {
    const element = stopButn[index];

    element.addEventListener('click', () => {
      current_audio_idx = index;
      stopSong();
    });
  }

  for (let index = 0; index < audio.length; index++) {
    const element = audio[index];
    element.addEventListener("timeupdate", updateProgress);
  }


  for (let index = 0; index < progressContainer.length; index++) {
    const element = progressContainer[index];
    //element.addEventListener("click", setProgress);
      element.addEventListener("click", function(e) {
      current_audio_idx = index;
      setProgress(e);
    });
  }
  

  //set progress Bar
  function setProgress(e) {
    const audioObj = audio[current_audio_idx]; 
    const width = progressContainer[current_audio_idx].clientWidth;
    const clickX = e.offsetX;
    const duration = audioObj.duration;
    audioObj.currentTime = (clickX / width) * duration;
  }


  function updateProgress(e) {
    //console.log('updateProgress', current_audio_idx);
    const { duration, currentTime } = e.srcElement;
    const progressPercent = (currentTime / duration) * 100;

    // 재생 100%일때 반복재생 버튼 전체재생 버튼 안 누른 상태

    if (current_audio_idx != null) {
      const element = document.querySelectorAll('.progress')[current_audio_idx];
      element.style.width = '' + progressPercent + '%';

      if (progressPercent == 100) {
        document.querySelectorAll('.music-container')[current_audio_idx].classList.remove('play');
        playButn[current_audio_idx].innerHTML = 'play';
        audio[current_audio_idx].currentTime = 0;
      }
    }
  }

  function playSong() {
    console.log(current_audio_idx);
    pauseSongAfterPlay();

    document.querySelectorAll('.music-container')[current_audio_idx].classList.add('play');
    playButn[current_audio_idx].innerHTML = 'pause';
    audio[current_audio_idx].play();    
  }

  function pauseSong() {
    //console.log(current_audio_idx);
    document.querySelectorAll('.music-container')[current_audio_idx].classList.remove('play');
    playButn[current_audio_idx].innerHTML = 'play';

    audio[current_audio_idx].pause();
  }

  function stopSong() {
    //console.log(current_audio_idx);

    for (let index = 0; index < audio.length; index++) {
      document.querySelectorAll('.music-container')[index].classList.remove('play');
      const element = document.querySelectorAll('.progress')[index].style.width = '0%';
      playButn[index].innerHTML = 'play';
      audio[index].pause();
    }
    audio[current_audio_idx].currentTime = 0;
  }

  function pauseSongAfterPlay() {
    
    for (let index = 0; index < audio.length; index++) {
      if (current_audio_idx !== index) {
        document.querySelectorAll('.music-container')[index].classList.remove('play');
        const element = document.querySelectorAll('.progress')[index].style.width = '0%';
        playButn[index].innerHTML = 'play';
        audio[index].pause();
        audio[index].currentTime = 0;
      }
    }
  }

}


// 임시 위치 찾기 

function showCoords(event) {

  var x = event.clientX;

  var y = event.clientY;

  var coords = "left: " + x + ", top: " + y;

  document.getElementById("demo").innerHTML = coords;

}